//	CDialogNewDisk.h
#ifndef _H_CDialogNewDisk
#define	_H_CDialogNewDisk

#include "FileSystemTypes.h"
#include "CDialog.h"

/**************************************************/
typedef enum {
	ADFS_NewDisk_NONE, 
	
	ADFS_NewDisk_OKAY, 
	ADFS_NewDisk_CANCEL, 
	
	ADFS_NewDisk_CHECK_NIBBLIZED,
	ADFS_NewDisk_POP_SECTOR_ORDER, 

	ADFS_NewDisk_POP_FORMAT, 
	ADFS_NewDisk_POP_OS, 
	ADFS_NewDisk_CHECK_BOOTABLE, 
	ADFS_NewDisk_POP_VOL_SIZE, 
	 
	ADFS_NewDisk_SIZE_TE, 
	ADFS_NewDisk_SIZE_UNITS, 
	
	ADFS_NewDisk_NUMTYPES
} ADFS_NewDiskType;

#define		ADFS_NewDisk_DISK_Gr_FIRST			ADFS_NewDisk_POP_OS
#define		ADFS_NewDisk_DISK_Gr_LAST			ADFS_NewDisk_SIZE_UNITS

#define		ADFS_NewDisk_SIZE_TE_Gr_FIRST		ADFS_NewDisk_SIZE_TE
#define		ADFS_NewDisk_SIZE_TE_Gr_LAST		ADFS_NewDisk_SIZE_UNITS

class	CDisk;
class	CDialogNewDisk;

/*************************************************/
//	pass a diskP if we're just doing the sector order dialog

enum {
	ND_Format_NONE, 

	ND_Format_RAW, 
	ND_Format_2IMG, 
	ND_Format_DISK_COPY, 

	ND_Format_NUMTYPES
};
typedef Byte	ND_DiskFileType;

typedef struct ND_DiscFormatRec {
	//	**WARNING this is a PREF struct
	//	it must be padded to an even size
	char /*FSType*/		sectorOrder;
	Boolean				nibblizedB;
	ND_DiskFileType		diskFileType;
	Byte				pad;
} ND_DiscFormatRec;

typedef	Boolean	(*ADFS_NewDiskDoneCB)(ADFS_NewDiskRec *newDiskP);

typedef struct ADFS_NewDiskRec {
	//	**WARNING this is a PREF struct
	//	it must be padded to an even size
	CDisk				*diskP;	//	could be NULL
	ND_DiscFormatRec	format;
	
	//	if diskP == NULL, then the rest of 
	//	this struct will be filled out
	long				bytesOnDiskL;

	unsigned char		unused7		: 1;
	unsigned char		unused6		: 1;
	unsigned char		unused5		: 1;
	unsigned char		unused4		: 1;
	unsigned char		unused3		: 1;
	unsigned char		unused2		: 1;

	unsigned char		disk2imgB 	: 1;
	unsigned char		bootableB	: 1;

	Boolean				customSizeB;
	Boolean				isMB;
	char /*FSType*/		osType;

	//	pad so next ptr starts on 4 byte boundary
	ADFS_NewDiskDoneCB	NewDiskDoneCB;
} ADFS_NewDiskRec;
/**************************************************/

CDialogNewDisk		*ShowNewDisk(ADFS_NewDiskRec *newDiskP);
CDialogNewDisk		*GetNewDisk(void);

FSType			ND_OSToSector(FSType osType);
ND_DiskFileType	ND_DiskTypeToFileType(DiskType diskType);

void			ImageRecToDiskFormatRec(
	DiskImageRec		*imageRecP, 
	ND_DiscFormatRec	*formatRecP);

/**************************************************/
class CDialogNewDisk : public CDialog {
	
	public:	Boolean		IDialogNewDisk(ADFS_NewDiskRec *newDiskP);

	virtual	void		Dispose(void);
	virtual	void		Finish(void);
	
	virtual	void		Move(EventRecord *event);
	virtual	Boolean		DoCommand(long command);
	virtual	void		DoKeyDown(EventRecord *theEvent);
	virtual	void		DoClick(EventRecord *theEvent);
	virtual	void		UpdateMenus(void);
	Boolean				VerifyText(short itemHit, TERestoreRec *restoreRec0);

	virtual	void		ValueConvert(
		DGI_ValueConvertType	convertType, 
		short					dlgItem);


	/*****************************************/
	ADFS_NewDiskRec	i_newDiskRec;
	ND_DiskFileType	i_origDiskFileType;
	
	Boolean			i_showSizePopB;
	Boolean			i_showSizeUnitsB;
	Boolean			i_showNibblizeB;
	Boolean			i_showSectorB;

	private:
	typedef 	CDialog		_inherited;
};

#endif
